<?php

/**
 * Class RootPageRedirect
 */
class RootPageRedirect extends PluginBase
{
    static protected $description = 'RootPageRedirect Plugin';
    static protected $name = 'RootPageRedirect';

    protected $storage = 'LimeSurvey\PluginManager\DbStorage';

    protected $settings = [
        'redirectUrl' => [
            'type' => 'string',
            'label' => 'RedirectUrl'
        ],
    ];

    /**
     * subscribe to all events
     */
    public function init()
    {
        $this->subscribe('beforeControllerAction');
    }

    /**
     * beforeControllerAction
     */
    public function beforeControllerAction()
    {
        $event = $this->getEvent();

        $controller = $event->get('controller');
        $action     = $event->get('action');

        if (Yii::app()->defaultController !== $controller) return;
        if (Yii::app()->controller->defaultAction !== $action) return;

        $url = $this->get('redirectUrl');
        if (strlen($url) === 0) return;

        Yii::app()->controller->redirect($url);
    }
}
