# LimeSurvey IPRangeSurvey Plugin

The IPRangeSurvey-Plugin grants access to a survey only for people within a certain range of network addresses.
This can be useful if people should only be allowed to execute a survey e.g. within the company's network.


## Plugin Features
- IP range details and redirect URKL can be defined at survey level
- Use CIDR-Notation to easily define valied IP ranges, see [Classless-Inter-Domain-Routing](https://de.wikipedia.org/wiki/Classless_Inter-Domain_Routing#%C3%9Cbersicht_f%C3%BCr_IPv4)

## Plugin Installation
- Copy the IPRangeSurvey-Folder to the Limesurvey "plugins" directory.
- Activate the plugin at the Limesurvey plugin manager (requires proper user rights for accessing the feature at the Limesurvey admin interface).

## Plugin Settings

- Allowed IP Range: see examples below and [Classless-Inter-Domain-Routing](https://de.wikipedia.org/wiki/Classless_Inter-Domain_Routing#%C3%9Cbersicht_f%C3%BCr_IPv4)
- Redirect Url: a URL where people will be redirectedto if access was denied based on their IP address, e. g. http://www.example.com

![Plugin Settings](./settings.png)


## Examples
|Notation        |Start IP     |EndIP          |Addresses|
|:--------------:|:-----------:|:-------------:|--------:|
|192.168.10.25/16|192.168.0.0  |192.168.255.255|65536    |
|192.168.10.25/17|192.168.0.0  |192.168.127.255|32768    |
|192.168.10.25/18|192.168.0.0  |192.168.63.255 |16348    |
|192.168.10.25/19|192.168.0.0  |192.168.31.255 |8192     |
|192.168.10.25/20|192.168.0.0  |192.168.15.255 |4096     |
|192.168.10.25/24|192.168.10.0 |192.168.10.255 |256      |
|192.168.10.25/26|192.168.10.0 |192.168.10.63  |64       |
|192.168.10.25/32|192.168.10.25|192.168.10.25  |1        |
