<?php

/**
 * Class Tokenizer
 * A Limesurvey Plugin to remove Tokens and their Responses
 */
class Rds extends PluginBase
{
    static protected $description = 'Rds Plugin';
    static protected $name = 'Rds';

    protected $storage = 'DbStorage';

    public function init()
    {
        $this->subscribe('beforeSurveySettings');
        $this->subscribe('newSurveySettings');
        $this->subscribe('beforeSurveyPage');
    }

    public function beforeSurveySettings()
    {
        $event = $this->event;

        $event->set("surveysettings.{$this->id}", array(
            'name' => get_class($this),
            'settings' => array(
                'isActive' => array(
                    'type' => 'boolean',
                    'label' => 'Active',
                    'default' => true,
                    'current' => $this->get('isActive', 'Survey', $event->get('survey')),
                    'help' => 'Activate the RDS plugin for this survey'
                ),
                'tokens' => array(
                    'type' => 'string',
                    'label' => 'Attributes for storing tokens',
                    'current' => $this->get('tokens', 'Survey', $this->event->get('survey'), ''),
                    'help' => 'Comma separated list of tokens. e.g attribute_1, attribute_2, attribute_3,...'
                ),
            )
        ));
    }

    public function newSurveySettings()
    {
        $event = $this->event;
        foreach ($event->get('settings') as $name => $value) {
            $this->set($name, $value, 'Survey', $event->get('survey'), '');
        }
    }

    public function beforeSurveyPage()
    {
        $event = $this->getEvent();
        $surveyId = $event->get('surveyId');

        $isActive = (bool) $this->get('isActive', 'Survey', $surveyId, false);
        if (!$isActive) return;

        $tokenString = Yii::app()->request->getParam('token');
        if (empty($tokenString)) return;

        $token = TokenDynamic::model($surveyId)->findByAttributes(['token' => $tokenString]);
        if (!$token) return;

        $this->generateTokensFor($token, $surveyId);
    }

	private function generateTokensFor($token, $surveyId)
	{
		$doSave = false;
		$plugin_setting = $this->get('tokens', 'Survey', $surveyId, false);
		$fields = array_map('trim', explode(',', $plugin_setting));

		foreach ($fields as $field) {
			// Kein property_exists – stattdessen direkt prüfen oder setzen
			if (!isset($token->$field) || empty($token->$field)) {
				$newToken = Token::create($surveyId);
				$newToken->setAttributes(['firstname' => '', 'lastname' => '', 'email' => '']);
				$newToken->generateToken();

				if ($newToken->save(false)) {
					$token->$field = $newToken->token;
					$doSave = true;
				}
			}
		}

		if ($doSave) {
			$token->save(false);
		}
	}
}
