$(document).ready(function(){
    if (!CalculateCompleteness_params) {
        return;
    }

    if (CalculateCompleteness_params.targetQuestion) {
        navigateToQuestion(CalculateCompleteness_params.targetQuestion);
    }

    addCompletenessCheckerModal();
    addCompletenessCheckerLink();
});

function addCompletenessCheckerLink() {
    // Don't add the link if no group/questions in page
    if (!$('.group-outer-container').length) {
        return;
    }

    var params = CalculateCompleteness_params;
    var navbar = $('#navbar .navbar-nav');
    var linkHtml = '<li><a id="completeness-checker-link" href="#" class="animate">' + params.linkLabel + '</a></li>';
    navbar.prepend($(linkHtml));

    bindComplenessCheckerLink();
}

function addCompletenessCheckerModal() {
    var params = CalculateCompleteness_params;
    $('body').append($(params.modalHtml));
}

function bindComplenessCheckerLink() {
    var params = CalculateCompleteness_params;
    $('#completeness-checker-link').on('click', function(){
        var modal = $('#completeness-checker-modal');
        var modalBody = modal.find('.modal-body-text');
        modalBody.html("");
        displaySpinner(modal);
        modal.modal();
        var csrfToken = $("#limesurvey input[name='YII_CSRF_TOKEN']").attr('value');
        $.ajax({
            method: 'POST',
            url: params.modalUrl,
            data: {
                YII_CSRF_TOKEN: csrfToken,
            }
        }).done(function(response) {
            response = response || {status: 'error', message: 'Empty server response'};
            var html = '';
            try {
                var data = (typeof response == "string") ? JSON.parse(response) : response;
                if (data.success) {
                    html = data.html;
                } else {
                    html = data.error;
                }
            } catch (ex) {
                html = ex;
            }
            hideSpinner(modal);
            modalBody.html(html);
            // Activate links
            activateActionLink();
        });
    });
}

function displaySpinner(parent)
{
    parent.find('#completeness-checker-loader').show();
}

function hideSpinner(parent)
{
    parent.find('#completeness-checker-loader').hide();
}

function navigateToQuestion(targetQuestion)
{
    var $target = $("#question" + targetQuestion);
    if ($target.length) {
        var targetTop = $target.offset().top - 100;
        window.scrollTo(0, targetTop);
    }
}